library("ecmwfr")

wf_set_key(user = "224407",
           key = "1d3e0b8d-d73a-4874-bf09-3bf4460af547",
           service = "cds")

month="12"

if(month=="02") {
  day = c("01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28")
} else if (month=="01" || month=="03" || month=="05" || month=="07" || month=="08" || month=="10" || month=="12") {
  day = c("01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31")
} else {
  day = c("01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30")
}

#Data from 1940
for(year in 1940:2023) {
  request <- list(
    product_type = "reanalysis",
    variable = "significant_height_of_combined_wind_waves_and_swell",
    year = paste0(year),
    month = month,
    day = day,
    time = c("00:00", "01:00", "02:00", "03:00", "04:00", "05:00", "06:00", "07:00", "08:00", "09:00", "10:00", "11:00", "12:00", "13:00", "14:00", "15:00", "16:00", "17:00", "18:00", "19:00", "20:00", "21:00", "22:00", "23:00"),
    area = c(90, -180, -90, 180),
    format = "grib",
    dataset_short_name = "reanalysis-era5-single-levels",
    target = paste0(year,'.grib')
  )
  ncfile <- wf_request(user    = "224407",
                       request  = request,
                       transfer = TRUE,
                       path     = paste0('F:/GRIB/',month,'/'),
                       verbose  = FALSE) 
}